# D Ncurses Examples

Here are a few examples to get you started.

Most of these examples are part of the [NCURSES Programming HOWTO](http://tldp.org/HOWTO/NCURSES-Programming-HOWTO/). The examples which were not taken from the HOWTO are marked with (N).

To run the examples, change to the specific directory and build and execute the example with "dub run".

## Examples

### Basics
  - acs_vars     - ACS variables example
  - hellounicode - a simple unicode example (N)
  - hello_world  - a simple hello world example
  - key_code     - returns the number code of the key you pressed
  - mouse_menu   - A menu accessible by mouse
  - other_border - Shows usage of other border functions apart from box()
  - printbold    - Gets a single character and displays it in bold (N)
  - printw_example - A very simple printw() example
  - simple_color - a simple example that demonstrates color output
  - simple_key   - A menu accessible with keyboard UP, DOWN  arrows
  - simplespectrum - Sample of 256-colour output (N)
  - temp_leave   - Demonstrates temporarily leaving curses mode
  - win_border   - Shows Creation of windows and borders
  - with_chgat   - chgat() usage example

### Forms
  - form_attrib  - Form attributes example

### Menus
  - menu_attrib  - Usage of menu attributes
  - menu_scroll  - Demonstrates scrolling capability of menus
  - menu_simple  - A simple menu accessed by arrow keys

### Panels
  - panel_simple - A simple panel example
  - ptest        - Panel test from PDCurses, shows moving, hiding and layering of panels (N)


## TODO
- [ ] review, and fix anything that's broken.
- [ ] cosmetic alterations.
- [ ] fix so that examples are compilable on Windows.

Again, please file any bugs that you come across.
Even if you don't know if it is actually a bug, we appreciate the time.
We understand that sometimes it is hard to figure out.
