import deimos.form;
import std.string;

void main()
{
    FIELD*[3] field;
    FORM* my_form;
    int ch;

    // Initialize curses
    initscr();
    start_color();
    cbreak();
    noecho();
    keypad(stdscr, true);
    scope (exit)
        endwin();

    // Initialize a few color pairs
    init_pair(1, COLOR_WHITE, COLOR_BLUE);
    init_pair(2, COLOR_WHITE, COLOR_BLUE);

    // Initialize the fields
    field[0] = new_field(1, 10, 4, 18, 0, 0);
    field[1] = new_field(1, 10, 6, 18, 0, 0);
    field[2] = null;

    // Set field options
    set_field_fore(field[0], COLOR_PAIR(1));    // Put the field with blue background
    set_field_back(field[0], COLOR_PAIR(2));    // and white foreground (characters
                                                // are printed in white
    field_opts_off(field[0], O_AUTOSKIP);       // Don't go to next field when this
                                                // Field is filled up
    set_field_back(field[1], A_UNDERLINE);
    field_opts_off(field[1], O_AUTOSKIP);

    // Create the form and post it
    my_form = new_form(field.ptr);
    post_form(my_form);
    refresh();

    set_current_field(my_form, field[0]);       // Set focus to the colored field
    mvprintw(4, 10, toStringz("Value 1:"));
    mvprintw(6, 10, toStringz("Value 2:"));
    mvprintw(LINES - 2, 0, toStringz("Use UP, DOWN arrow keys to switch between fields"));
    refresh();

    // Loop through to get user requests
    while_loop: while ((ch = getch()) != KEY_F(1))
    {
        switch (ch)
        {
        case KEY_DOWN:
            // Go to the next field
            form_driver(my_form, REQ_NEXT_FIELD);
            // Go to the end of the present buffer
            // Leaves nicely at the last character
            form_driver(my_form, REQ_END_LINE);
            break;
        case KEY_UP:
            // Go to previous field
            form_driver(my_form, REQ_PREV_FIELD);
            form_driver(my_form, REQ_END_LINE);
            break;
        default:
            // If this is a normal character, it gets Printed
            form_driver(my_form, ch);
            break;
        } // switch
    } // while

    // Un post form and free the memory
    unpost_form(my_form);
    free_form(my_form);
    free_field(field[0]);
    free_field(field[1]);
} // main
